unit Unit1;

interface

{$E SCR}
{$D SCRNSAVE Ping Pong Screen Saver}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Inifiles, Registry;

type
  TMainFrm = class(TForm)
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormDestroy(Sender: TObject);
  private
    FBitMap : TBitmap;
    FPosX,FPosY : Integer;
    FIncrX, FIncrY : Integer;
    FPosMouse : TPoint;
    procedure CloseScreenSaver;
  public
    { Public declarations }
  end;

var
  MainFrm: TMainFrm;

implementation

{$R *.DFM}
{$R BITRES.RES}

procedure TMainFrm.FormCreate(Sender: TObject);
var
  Inifile : TInifile;
  Dummy : Boolean;
begin
  Randomize;
// l parmetros de velocidade
  IniFile := TInifile.Create('CONTROL.INI');
  Timer1.Interval := -5*Inifile.ReadInteger('Screen Saver.Ping','Position',50)+501;
  Timer1.Enabled := True;
  IniFile.Free;
// l bitmap de recurso
  FBitmap := TBitmap.Create;
  FBitmap.LoadFromResourceName(hInstance,'PING');
  FPosX := Random(ClientWidth-50);
  FPosY := Random(ClientHeight-50);
  FIncrX := 3;
  FIncrY := 3;
// esconde cursor
  ShowCursor(False);
// pega posio do cursor
  GetCursorPos(FPosMouse);
// avisa que h um Screen Saver ativo
  SystemParametersInfo(SPI_SCREENSAVERRUNNING,1,@Dummy,0);
end;

procedure TMainFrm.Timer1Timer(Sender: TObject);
begin
// efeito ping-pong
  Inc(FPosX,FIncrX);
  if FPosX > ClientWidth-50 then begin
    FPosX := ClientWidth-50;
    FIncrX := -FIncrX;
  end
  else if FPosX < 0 then begin
    FPosX := 0;
    FIncrX := -FIncrX;
  end;
  Inc(FPosY,FIncrY);
  if FPosY > ClientHeight-50 then begin
    FPosY := ClientHeight-50;
    FIncrY := -FIncrY;
  end
  else if FPosY < 0 then begin
    FPosY := 0;
    FIncrY := -FIncrY;
  end;
// desenha bitmap
  BitBlt(Canvas.Handle,FPosX,FPosY,50,50,FBitmap.Canvas.Handle,0,0,SRCCOPY);
end;

procedure TMainFrm.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if (Abs(FPosMouse.X-X) > 5) or (Abs(FPosMouse.Y-Y) > 5) then
    CloseScreenSaver
  else begin
    FPosMouse.X := X;
    FPosMouse.Y := Y;
  end;
end;

procedure TMainFrm.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  CloseScreenSaver;
end;

procedure TMainFrm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  CloseScreenSaver;
end;

procedure TMainFrm.CloseScreenSaver;
var
  Reg : TRegistry;
  SysDir : String;
  TamDir : Integer;
  LibSenha : THandle;
  FuncSenha : function(ParentWnd : THandle) : Boolean; stdcall;
begin
  Reg := TRegistry.Create;
  try
// verifica se tem senha
    Reg.RootKey := HKEY_CURRENT_USER;
    if Reg.OpenKey('Control Panel\Desktop',False) then
      if Reg.ReadInteger('ScreenSaveUsePassword') <> 0 then begin
// mostra cursor do mouse
        ShowCursor(True);
        try
// abre biblioteca Password.cpl
          SetLength(SysDir, MAX_PATH);
          TamDir := GetSystemDirectory(PChar(SysDir),MAX_PATH);
          SetLength(SysDir,TamDir);
          if (SysDir <> '') and (SysDir[Length(SysDir)] <> '\') then
            SysDir := SysDir + '\';
          LibSenha := LoadLibrary(PChar(SysDir+'PASSWORD.CPL'));
          if LibSenha <> 0 then begin
// pega funo de verificao de senha e chama-a
            FuncSenha := GetProcAddress(LibSenha,'VerifyScreenSavePwd');
            if Assigned(FuncSenha) and not FuncSenha(Handle) then begin
// teclou cancela - volta  execuo
              FreeLibrary(LibSenha);
              GetCursorPos(FPosMouse);
              exit;
            end;
            FreeLibrary(LibSenha);
          end;
        finally
          ShowCursor(False);
        end;
      end;
// fecha o screen saver
    Close;
  finally
    Reg.Free;
  end;
end;

procedure TMainFrm.FormDestroy(Sender: TObject);
var
  Dummy : Boolean;
begin
  FBitmap.Free;
  SystemParametersInfo(SPI_SCREENSAVERRUNNING,0,@Dummy,0);
  ShowCursor(True);
end;

end.
